/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter.resources;

import com.fusioncharts.exporter.beans.ChartMetadata;
import com.fusioncharts.exporter.beans.ExportBean;
import com.fusioncharts.exporter.beans.ExportConfiguration;
import com.fusioncharts.exporter.beans.ExportParameterNames;
import com.fusioncharts.exporter.beans.LogMessageSetVO;
import com.fusioncharts.exporter.error.ErrorHandler;
import com.fusioncharts.exporter.error.LOGMESSAGE;
import com.fusioncharts.exporter.error.Status;
import com.fusioncharts.exporter.helper.FusionChartsExportHelper;
import com.fusioncharts.exporter.helper.InputValidator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;

public class FCExporter_SVG2ALL {
    private ExportBean exportBean = null;
    private InputValidator inputValidator = new InputValidator();
    private ByteArrayOutputStream exportObject;
    private String appPath = new String();
    private static Logger logger = null;

    public FCExporter_SVG2ALL(String realPath, ExportBean exportBean) {
        this.appPath = realPath + "/";
        this.exportBean = exportBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream exportProcessor(HttpServletResponse response) {
        String OS = System.getProperty("os.name");
        System.out.println(OS);
        String exportFormat = (String)this.exportBean.getExportParameterValue("exportformat");
        String extension = FusionChartsExportHelper.getExtensionFor(exportFormat.toLowerCase());
        LogMessageSetVO errorSetVO = new LogMessageSetVO();
        String exportTargetWindow = (String)this.exportBean.getExportParameterValue(ExportParameterNames.EXPORTTARGETWINDOW.toString());
        boolean isHTML = this.exportBean.isHTMLResponse();
        String meta_values = this.exportBean.getMetadataAsQueryString(null, true, isHTML);
        JSONObject bgImgMeta = this.exportBean.getMetadata().getBgImage();
        String extension2 = new String();
        if (extension.equals("jpeg") || extension.equals("jpg")) {
            extension = "png";
            extension2 = "jpg";
        }
        if (!extension.equals("svg")) {
            File outImgFile;
            this.createDirectory("", "fusioncharts_temp");
            this.createDirectory("fusioncharts_temp/", "temp");
            long timeInMills = System.currentTimeMillis();
            String tempName = new String("temp" + timeInMills);
            String tempOutputFileName = null;
            String tempOutputJpgFileName = null;
            if (OS.startsWith("Windows")) {
                tempOutputFileName = new String(this.appPath + "fusioncharts_temp/" + tempName + "." + extension);
                tempOutputJpgFileName = new String(this.appPath + "fusioncharts_temp/" + tempName + ".jpg");
            } else if (OS.startsWith("Linux")) {
                tempOutputFileName = new String(this.appPath + "fusioncharts_temp/" + tempName + "." + extension);
                tempOutputJpgFileName = new String(this.appPath + "fusioncharts_temp/" + tempName + ".jpg");
            }
            String inkscapePath = new String(ExportConfiguration.INKSCAPE_PATH);
            String imageMagickPath = new String(ExportConfiguration.IMAGEMAGICK_PATH);
            ChartMetadata metadata = this.exportBean.getMetadata();
            Double width = new Double(metadata.getWidth());
            Double height = new Double(metadata.getHeight());
            String size = new String();
            if (width != null && height != null) {
                size = "-w " + width + " -h " + height;
            }
            if (extension.equals("pdf")) {
                size = "";
            }
            String bgcolor = new String();
            bgcolor = metadata.getBgColor();
            if (bgcolor.equalsIgnoreCase(null) || bgcolor.equalsIgnoreCase("") || bgcolor.equalsIgnoreCase(null)) {
                bgcolor = "FFFFFF";
            }
            String bg = new String();
            if (!bgcolor.isEmpty()) {
                bg = " --export-background=" + bgcolor;
            }
            File svgFile = null;
            File tempBgImgFile = null;
            try {
                svgFile = File.createTempFile("fusioncahrts", ".svg", new File(this.appPath + "fusioncharts_temp"));
                String svgStr = this.exportBean.getStream();
                if (bgImgMeta != null) {
                    String encodingPrefix = "base64,";
                    Iterator imageItr = bgImgMeta.keys();
                    String imgKey = null;
                    while (imageItr.hasNext()) {
                        FileOutputStream _imgStream;
                        imgKey = (String)imageItr.next();
                        String dataURL = (String)((JSONObject)bgImgMeta.get(imgKey)).get("encodedData");
                        String imgName = (String)((JSONObject)bgImgMeta.get(imgKey)).get("name");
                        String imgExt = (String)((JSONObject)bgImgMeta.get(imgKey)).get("type");
                        int contentStartIndex = dataURL.indexOf(encodingPrefix) + encodingPrefix.length();
                        String bgImgEncoded = dataURL.substring(contentStartIndex);
                        tempBgImgFile = this.createOrOverrideFile(this.appPath + "fusioncharts_temp/temp/" + imgName + "." + imgExt);
                        if (tempBgImgFile != null && (_imgStream = new FileOutputStream(tempBgImgFile)) != null) {
                            ((OutputStream)_imgStream).write(Base64.decodeBase64((byte[])bgImgEncoded.getBytes()));
                            ((OutputStream)_imgStream).close();
                        }
                        String fullImgName = imgName + "." + imgExt;
                        String svgImgRef = "temp/" + fullImgName;
                        while (svgStr.indexOf(svgImgRef) != -1) {
                            svgStr = svgStr.replaceAll(svgImgRef, dataURL);
                        }
                    }
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(svgFile));
                bw.write(svgStr);
                bw.close();
            }
            catch (IOException e) {
                errorSetVO.addError(LOGMESSAGE.E518);
                errorSetVO.setOtherMessages(meta_values);
                this.writeError(response, isHTML, errorSetVO, exportTargetWindow);
                return null;
            }
            StringBuffer sBuff = new StringBuffer();
            sBuff.append("inkscape " + bg);
            sBuff.append(" --without-gui " + svgFile);
            sBuff.append(" --export-" + extension + "=" + tempOutputFileName);
            sBuff.append(" " + size);
            String cmd = sBuff.toString();
            System.out.println("Command Inkscape :" + cmd);
            if (OS.startsWith("Windows")) {
                ProcessBuilder builder = new ProcessBuilder("CMD", "/C", cmd);
                builder.redirectErrorStream(true);
                builder.directory(new File(inkscapePath));
                Process p = null;
                try {
                    p = builder.start();
                    BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = null;
                    while ((line = r.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (IOException e) {
                    errorSetVO.addError(LOGMESSAGE.E519);
                    errorSetVO.setOtherMessages(meta_values);
                    this.writeError(response, isHTML, errorSetVO, exportTargetWindow);
                    return null;
                }
            }
            if (OS.startsWith("Linux")) {
                Process p = null;
                try {
                    p = Runtime.getRuntime().exec(cmd);
                    BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = null;
                    while ((line = r.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (IOException e) {
                    errorSetVO.addError(LOGMESSAGE.E519);
                    errorSetVO.setOtherMessages(meta_values);
                    this.writeError(response, isHTML, errorSetVO, exportTargetWindow);
                    return null;
                }
            }
            if (extension2.equals("jpg")) {
                StringBuffer sBuffJPG = new StringBuffer();
                sBuffJPG.append("convert -quality 100 " + tempOutputFileName + " " + tempOutputJpgFileName);
                tempOutputFileName = tempOutputJpgFileName;
                String cmdJPG = sBuffJPG.toString();
                System.out.println("Command ImageMagick :" + cmdJPG);
                if (OS.startsWith("Windows")) {
                    ProcessBuilder builderJPG = new ProcessBuilder("CMD", "/C", cmdJPG);
                    builderJPG.redirectErrorStream(true);
                    builderJPG.directory(new File(imageMagickPath));
                    Process pJPG = null;
                    try {
                        pJPG = builderJPG.start();
                        BufferedReader r2 = new BufferedReader(new InputStreamReader(pJPG.getInputStream()));
                        String line2 = null;
                        while ((line2 = r2.readLine()) != null) {
                            System.out.println(line2);
                        }
                    }
                    catch (IOException e) {
                        errorSetVO.addError(LOGMESSAGE.E520);
                        errorSetVO.setOtherMessages(meta_values);
                        this.writeError(response, isHTML, errorSetVO, exportTargetWindow);
                        return null;
                    }
                }
                if (OS.startsWith("Linux")) {
                    Process pJPG = null;
                    try {
                        pJPG = Runtime.getRuntime().exec(cmdJPG);
                        BufferedReader r = new BufferedReader(new InputStreamReader(pJPG.getInputStream()));
                        String line = null;
                        while ((line = r.readLine()) != null) {
                            System.out.println(line);
                        }
                    }
                    catch (IOException e) {
                        errorSetVO.addError(LOGMESSAGE.E519);
                        errorSetVO.setOtherMessages(meta_values);
                        this.writeError(response, isHTML, errorSetVO, exportTargetWindow);
                        return null;
                    }
                }
            }
            if ((outImgFile = new File(tempOutputFileName)).length() < 10L) {
                errorSetVO.addError(LOGMESSAGE.E521);
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(outImgFile);
            }
            catch (FileNotFoundException e) {
                errorSetVO.addError(LOGMESSAGE.E521);
                errorSetVO.setOtherMessages(meta_values);
                this.writeError(response, isHTML, errorSetVO, exportTargetWindow);
                return null;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            try {
                int readNum;
                while ((readNum = fis.read(buf)) != -1) {
                    bos.write(buf, 0, readNum);
                }
            }
            catch (IOException ex) {
                errorSetVO.addError(LOGMESSAGE.E522);
                ex.printStackTrace();
                this.writeError(response, isHTML, errorSetVO, exportTargetWindow);
                ByteArrayOutputStream byteArrayOutputStream = null;
                return byteArrayOutputStream;
            }
            finally {
                try {
                    fis.close();
                    bos.close();
                }
                catch (IOException e) {
                    System.out.println("error in closing file input or byte input");
                    e.printStackTrace();
                }
            }
            this.exportObject = bos;
        } else if (extension.equals("svg")) {
            String imgKey = null;
            String svgStr = this.exportBean.getStream();
            if (bgImgMeta != null) {
                Iterator imageItr = bgImgMeta.keys();
                while (imageItr.hasNext()) {
                    imgKey = (String)imageItr.next();
                    String dataURL = (String)((JSONObject)bgImgMeta.get(imgKey)).get("encodedData");
                    String imgName = (String)((JSONObject)bgImgMeta.get(imgKey)).get("name");
                    String imgExt = (String)((JSONObject)bgImgMeta.get(imgKey)).get("type");
                    String fullImgName = imgName + "." + imgExt;
                    String svgImgRef = "temp/" + fullImgName;
                    while (svgStr.indexOf(svgImgRef) != -1) {
                        svgStr = svgStr.replaceAll(svgImgRef, dataURL);
                    }
                }
            }
            byte[] buf = svgStr.getBytes();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
            bos.write(buf, 0, buf.length);
            this.exportObject = bos;
        } else {
            errorSetVO.addError(LOGMESSAGE.E517);
            errorSetVO.setOtherMessages(meta_values);
            this.writeError(response, isHTML, errorSetVO, exportTargetWindow);
            return null;
        }
        return this.exportObject;
    }

    public String exportOutput(ByteArrayOutputStream exportObject, HttpServletResponse response) {
        String action = (String)this.exportBean.getExportParameterValue("exportaction");
        String exportFormat = (String)this.exportBean.getExportParameterValue("exportformat");
        String exportTargetWindow = (String)this.exportBean.getExportParameterValue("exporttargetwindow");
        String fileNameWithoutExt = (String)this.exportBean.getExportParameterValue("exportfilename");
        String extension = FusionChartsExportHelper.getExtensionFor(exportFormat.toLowerCase());
        fileNameWithoutExt = this.inputValidator.checkForMaliciousCharaters(fileNameWithoutExt);
        String fileName = fileNameWithoutExt + "." + extension;
        boolean isHTML = false;
        if (action.equals("download")) {
            isHTML = true;
        }
        LogMessageSetVO logMessageSetVO = new LogMessageSetVO();
        String noticeMessage = "";
        String meta_values = this.exportBean.getMetadataAsQueryString(null, false, isHTML);
        if (!action.equals("download")) {
            noticeMessage = "&notice=";
            String pathToSaveFolder = ExportConfiguration.SAVEABSOLUTEPATH;
            String completeFilePath = pathToSaveFolder + File.separator + fileName;
            String completeFilePathWithoutExt = pathToSaveFolder + File.separator + fileNameWithoutExt;
            File saveFile = new File(completeFilePath);
            if (saveFile.exists()) {
                noticeMessage = noticeMessage + (Object)((Object)LOGMESSAGE.W509);
                if (!ExportConfiguration.OVERWRITEFILE && ExportConfiguration.INTELLIGENTFILENAMING) {
                    noticeMessage = noticeMessage + (Object)((Object)LOGMESSAGE.W514);
                    completeFilePath = FusionChartsExportHelper.getUniqueFileName(completeFilePathWithoutExt, extension);
                    File tempFile = new File(completeFilePath);
                    fileName = tempFile.getName();
                    noticeMessage = noticeMessage + (Object)((Object)LOGMESSAGE.W515) + fileName;
                    logMessageSetVO.addWarning(LOGMESSAGE.W515);
                }
            }
            String pathToDisplay = ExportConfiguration.HTTP_URI + "/" + fileName;
            if (ExportConfiguration.HTTP_URI.endsWith("/")) {
                pathToDisplay = ExportConfiguration.HTTP_URI + fileName;
            }
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(completeFilePath);
                exportObject.writeTo(outputStream);
                ((OutputStream)outputStream).close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                System.out.println("File not found!!");
                return null;
            }
            catch (IOException e) {
                System.out.println("Error in writing to file!!");
                e.printStackTrace();
                return null;
            }
            meta_values = this.exportBean.getMetadataAsQueryString(pathToDisplay, false, isHTML);
            if (logMessageSetVO.getErrorsSet() == null || logMessageSetVO.getErrorsSet().isEmpty()) {
                try {
                    PrintWriter out = response.getWriter();
                    out.print(meta_values + noticeMessage + "&statusCode=" + Status.SUCCESS.getCode() + "&statusMessage=" + (Object)((Object)Status.SUCCESS));
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            response.setContentType(FusionChartsExportHelper.getMimeTypeFor(exportFormat.toLowerCase()));
            if (exportTargetWindow.equalsIgnoreCase("_self")) {
                response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            } else {
                response.addHeader("Content-Disposition", "inline; filename=\"" + fileName + "\"");
            }
            byte[] bytes = exportObject.toByteArray();
            response.setContentLength(bytes.length);
            try {
                ServletOutputStream outStream = response.getOutputStream();
                outStream.write(bytes);
                outStream.close();
            }
            catch (Throwable e) {
                return null;
            }
        }
        return "success";
    }

    private void createDirectory(String baseprefix, String dirName) {
        File f = new File(this.appPath + baseprefix + dirName);
        if (!f.exists()) {
            f.mkdir();
        }
    }

    private File createOrOverrideFile(String filePath) {
        File f = new File(filePath);
        if (!f.exists() || f.isDirectory()) {
            try {
                f.createNewFile();
                return f;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void deleteFilesInFolder(String folderPath) {
        File temp_folder = new File(folderPath);
        if (temp_folder.isDirectory()) {
            String[] entries;
            for (String s : entries = temp_folder.list()) {
                File currentFile = new File(temp_folder.getPath(), s);
                currentFile.delete();
            }
            temp_folder.delete();
        }
    }

    private void writeError(HttpServletResponse response, boolean isHTML, LogMessageSetVO logMessageSetVO, String exportTargetWindow) {
        response.setContentType("text/html");
        if (exportTargetWindow != null && exportTargetWindow.equalsIgnoreCase("_self")) {
            response.addHeader("Content-Disposition", "attachment;");
        } else {
            response.addHeader("Content-Disposition", "inline;");
        }
        try {
            PrintWriter out = response.getWriter();
            out.print(ErrorHandler.buildResponse(logMessageSetVO, isHTML));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    static {
        logger = Logger.getLogger(FCExporter_SVG2ALL.class.getName());
    }
}

